from setuptools import setup, find_packages

# Read the contents of your README file
with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="FLAMES_model",
    version="0.1.0",
    author="Your Name",
    author_email="your.email@example.com",
    description="An implementation of FLAMES Model for Sequential CIFAR-10/100 classification",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/yourusername/FLAMES_model",
    project_urls={
        "Bug Tracker": "https://github.com/yourusername/FLAMES_model/issues",
    },
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Intended Audience :: Researchers",
        "Intended Audience :: Developers",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
    ],
    packages=find_packages(),
    python_requires=">=3.7",
    install_requires=[
        "torch>=1.9.0",
        "torchvision>=0.10.0",
        "matplotlib>=3.4.0",
        "numpy>=1.19.5",
        "PyYAML>=5.4",
        "tensorboard>=2.5.0"
    ],
    extras_require={
        "dev": [
            "pytest>=6.0",
            "flake8>=3.9",
            "black>=21.7b0",
        ],
    },
    entry_points={
        "console_scripts": [
            "train_FLAMES=scripts.train:main",
            "evaluate_FLAMES=scripts.evaluate:main",
            "visualize_FLAMES=scripts.visualization:main",
        ],
    },
    include_package_data=True,
)
